//
//  MCCreateAndEditAbstractView.h
//  MCApplication
//
//  Created by Michael Clark on 30/03/05.
//  Copyright 2005 __MyCompanyName__. All rights reserved.
//

#import <Cocoa/Cocoa.h>

#import <MCApplication/MCDocument.h>
#import <MCApplication/MCNibLoadingView.h>
#import "MCMenuManagerSupportProtocol.h"

@class MCHelpController;

@interface MCCreateAndEditAbstractView : MCNibLoadingView <MCMenuManagerSupport> {
	id                                _object;
    id                                _origObject;

	IBOutlet NSView*                  mainView;
	IBOutlet NSArrayController*       linkedObjectsController;
	IBOutlet NSObjectController*      objectController;
	IBOutlet NSObjectController*      filesOwnerController;
    IBOutlet MCHelpController        *helpController;
	
    IBOutlet id __firstResponder;

	IBOutlet NSView                  *accessoryView;
    
    MCDocument* __document;
    
    NSTextField* nextStepTextField;
    NSPopUpButton* nextStepPopUp;
	
	NSMutableArray*                   _liveLinkedObjects;
    
    BOOL isObjectEditable;
	
	// Only used when editing, we on the view after willSaveObject is called, but before didSaveObject is called
	NSDictionary*         __changedAttributes;

	BOOL shouldAutoLink;
}

- (void)configure;

- (NSArray*)objectsToLink;

- (id)document;
- (void)setDocument:(id)aDocument;

- (void)setObject: (id)object;
- (id)object;

- (id)origObject;
- (void)setOrigObject:(id)anOrigObject;

- (BOOL)isObjectEditable;
- (void)setIsObjectEditable:(BOOL)flag;

- (BOOL)editingObject;

- (NSArray *)preLinkedObjects;
- (void)setPreLinkedObjects:(NSArray *)aPreLinkedObjects;

// Called by the hosting MCCreateAndEditWindowController
- (BOOL)willSaveObject;
- (BOOL)willCancelObject;

- (void)didSaveObject;
- (void)didCancelObject;

- (BOOL)hasChanges;
- (NSArray *)changedAttributesWithoutModifyDateAndPrimaryKeyForObject:(id)anObj;

- (id)cloneObject:(id)anObject;

- (void)setNextStepVars;
- (void)setupNextStep;
- (void)syncNextStepPopUpWithDefaults;

- (id)mcFirstResponder;

// Subclassers return yes if they want this set up for them when the view gets configured
- (BOOL)hasWindowTitleGoToArrow;
- (IBAction)goToWindowTitleButtonDidAct:(id)sender;

- (void)setupHelpButton;

#pragma mark Accessors
- (NSView *)accessoryView;

- (NSDictionary *)changedAttributes;
- (void)setChangedAttributes:(NSDictionary *)aChangedAttributes;

- (id)nextStepPopUp;

- (BOOL)shouldAutoLink;
- (void)setShouldAutoLink:(BOOL)flag;
@end
